
<?php
// === CONFIG ===
$BOT_TOKEN = "8308174105:AAHNpQ8KRuHzcxvDRwOf26geva7ZpHaocis";
$WEBAPP_URL = "https://kien.kiemtienngay.us/public";
$ADMIN_CHAT_ID = 7287969285;
$API_URL = "https://api.telegram.org/bot$BOT_TOKEN/";

// === FUNCTIONS ===
function sendMessage($chat_id, $text, $reply_markup = null) {
    global $API_URL;
    $data = [
        "chat_id" => $chat_id,
        "text" => $text,
        "parse_mode" => "HTML"
    ];
    if($reply_markup) $data["reply_markup"] = json_encode($reply_markup);
    file_get_contents($API_URL . "sendMessage?" . http_build_query($data));
}

// === CONNECT DB ===
$pdo = new PDO("mysql:host=localhost;dbname=nsoshinp_kien;charset=utf8", "nsoshinp_kien", "nsoshinp_kien");

// === SETTINGS TABLE ===
function getSetting($key, $default = null) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT value FROM settings WHERE name=?");
    $stmt->execute([$key]);
    $val = $stmt->fetchColumn();
    return $val !== false ? $val : $default;
}
function setSetting($key, $val) {
    global $pdo;
    $stmt = $pdo->prepare("REPLACE INTO settings (name,value) VALUES (?,?)");
    $stmt->execute([$key, $val]);
}

// === HANDLE UPDATE ===
$update = json_decode(file_get_contents("php://input"), true);
if(!$update) exit;

// === HANDLE CALLBACK QUERY (DUYỆT/HỦY RÚT TIỀN) ===
if(isset($update['callback_query'])){
    $callback = $update['callback_query'];
    $data = $callback['data'] ?? '';
    $chat_id = $callback['message']['chat']['id'];
    $message_id = $callback['message']['message_id'];

    if(preg_match('/^(approve|cancel)_(\d+)$/', $data, $matches)){
        $action = $matches[1];
        $withdraw_id = intval($matches[2]);
        $status = $action === 'approve' ? 'Thành công' : 'Đã hủy';

        if($action === 'cancel'){
            $stmtAmount = $pdo->prepare("SELECT user_id, amount FROM withdraws WHERE id=?");
            $stmtAmount->execute([$withdraw_id]);
            $row = $stmtAmount->fetch(PDO::FETCH_ASSOC);
            if($row){
                $pdo->prepare("UPDATE users SET coins = coins + ? WHERE id=?")
                    ->execute([$row['amount'], $row['user_id']]);
            }
        }

        $pdo->prepare("UPDATE withdraws SET status=? WHERE id=?")
            ->execute([$status, $withdraw_id]);

        file_get_contents($API_URL . "editMessageText?" . http_build_query([
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => "📤 Yêu cầu rút tiền #$withdraw_id\nTrạng thái: $status",
            'parse_mode' => 'HTML'
        ]));

        $stmt2 = $pdo->prepare("SELECT user_id FROM withdraws WHERE id=?");
        $stmt2->execute([$withdraw_id]);
        $user_id = $stmt2->fetchColumn();

        if($user_id){
            $msg_user = $action === 'approve' 
                ? "✅ Yêu cầu rút tiền #$withdraw_id của bạn đã được duyệt!" 
                : "❌ Yêu cầu rút tiền #$withdraw_id đã bị hủy! Xu đã được hoàn lại.";
            sendMessage($user_id, $msg_user);
        }
    }
    exit;
}

// === ANTI-LINK IN GROUPS ===
if(isset($update['message'])){
    $msg = $update['message'];
    $chat_id = $msg['chat']['id'];
    $text    = $msg['text'] ?? '';

    // Nếu đang khóa links và là group
    $allow = getSetting("allow_links", "1");
    if($allow !== "1" && $chat_id < 0 && $text){
        // Kiểm tra quyền của user
        $uid = $msg['from']['id'];

        // Lấy thông tin member để kiểm tra có phải admin/owner không
        $res = file_get_contents($API_URL . "getChatMember?" . http_build_query([
            "chat_id" => $chat_id,
            "user_id" => $uid
        ]));
        $member = json_decode($res, true);
        $status = $member['result']['status'] ?? '';

        $isAdmin = in_array($status, ['administrator','creator']);

        // Nếu không phải admin => kiểm tra link/@
        if(!$isAdmin && preg_match('/https?:\/\/\S+|t\.me\/\S+|@\w+/i', $text)){
            // Ngoại lệ: cho phép link https://t.me/thongbaotelepet
            if(stripos($text, "https://t.me/thongbaotelepet") === false){
                $message_id = $msg['message_id'];

                // Xóa tin nhắn
                file_get_contents($API_URL . "deleteMessage?" . http_build_query([
                    "chat_id" => $chat_id,
                    "message_id" => $message_id
                ]));

                // Thông báo riêng cho user (nếu muốn)
                // sendMessage($uid, "⛔ Nhóm hiện đang cấm gửi link/@username. Tin nhắn của bạn đã bị xóa!");
            }
        }
    }
}



// === HANDLE WEBAPP (RÚT TIỀN) ===
$chat_id = $update["message"]["chat"]["id"] ?? null;
$webapp_data = $update["message"]["web_app_data"]["data"] ?? null;
if($webapp_data){
    $data = json_decode($webapp_data, true);
    if(!$data) exit;

    $user_id = $chat_id;
    $method   = strtoupper($data['method'] ?? '');
    $account  = trim($data['account'] ?? '');
    $amount   = intval($data['amount'] ?? 0);
    $namebank = trim($data['namebank'] ?? '');
    $nametk   = trim($data['nametk'] ?? '');
    $vnd      = $amount * 0.02;

    if(!$method || !$account || !$amount){
        sendMessage($chat_id, "❌ Vui lòng nhập đầy đủ thông tin rút tiền!");
        exit;
    }

    $stmt = $pdo->prepare("INSERT INTO withdraws (user_id, method, account, amount, status, created_at, namebank, nametk, vnd) VALUES (?, ?, ?, ?, 'pending', NOW(), ?, ?, ?)");
    $stmt->execute([$user_id, $method, $account, $amount, $namebank, $nametk, $vnd]);
    $withdraw_id = $pdo->lastInsertId();

    $text_admin = "📤 Yêu cầu rút tiền mới\nID: $withdraw_id\nUser: $user_id\nSố tiền: ".number_format($amount,0,',','.')." xu (~".number_format($vnd,0,',','.')." VND)\nPhương thức: $method\nTài khoản: $account\nNgân Hàng: $nametk\nTên nhận: $namebank\nTrạng thái: Đang xử lý";

    $buttons = [
        [
            ["text"=>"✅ Duyệt","callback_data"=>"approve_$withdraw_id"],
            ["text"=>"❌ Hủy","callback_data"=>"cancel_$withdraw_id"]
        ]
    ];
    sendMessage($ADMIN_CHAT_ID, $text_admin, ['inline_keyboard'=>$buttons]);
    sendMessage($chat_id, "✅ Yêu cầu rút tiền đã được gửi, đang chờ admin duyệt!");
    exit;
}

// === HANDLE COMMANDS ===
$text = $update["message"]["text"] ?? "";
if(!$chat_id || !$text) exit;

// === LỆNH THÔNG BÁO AN TOÀN ===
$isThongBao = ($chat_id == $ADMIN_CHAT_ID && preg_match("/^\/thongbao (.+)$/", $text, $m));

switch(true){
    case $text === "/start":
        $msg = "🎉 Chào mừng bạn đến với <b>TelePet Clicker</b>!\n\n".
               "✨ MiniApp kiếm xu miễn phí\n".
               "👉 Nuôi Pet - Điểm danh - Mở rương kiếm xu\n".
               "💰 Min rút chỉ 2.000 vnđ\n".
               "✔️ Hỗ trợ tất cả ngân hàng";
        $markup = ["inline_keyboard"=>[[["text"=>"🚀 Mở Mini App","web_app"=>["url"=>$WEBAPP_URL]]]]];
        sendMessage($chat_id, $msg, $markup);
        break;
        
            case $text === "/thongke" && $chat_id == $ADMIN_CHAT_ID:
        $stmt = $pdo->query("SELECT COUNT(*) as total_don, SUM(vnd) as tong_tien FROM withdraws WHERE status = 'Thành công'");
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $total_don = $row['total_don'] ?? 0;
        $tong_tien = $row['tong_tien'] ?? 0;
        sendMessage($chat_id, "📈 Thống kê rút tiền:\n• Số đơn đã duyệt: <b>$total_don</b>\n• Tổng tiền đã rút: <b>".number_format($tong_tien, 0, ',', '.')."đ</b>");
        break;


    case $text === "/help":
        sendMessage($chat_id, "📖 Hướng dẫn:\n/start - Bắt đầu\n/withdraw - Rút xu\n/stats - Thống kê\n/game - Mở MiniApp");
        break;

    case $text === "/withdraw":
        sendMessage($chat_id, "💸 Vào MiniApp để rút xu.\nAdmin sẽ duyệt sau.");
        break;

    case $text === "/stats":
        sendMessage($chat_id, "📊 Thống kê của bạn:\n• Xu: 0\n• Bạn bè: 0\n• Tổng rút: 0");
        break;

    case $text === "/game" || $text === "/play":
        $markup = ["inline_keyboard"=>[[["text"=>"🎮 Chơi ngay","web_app"=>["url"=>$WEBAPP_URL]]]]];
        sendMessage($chat_id, "🚀 Bấm nút dưới để mở MiniApp:", $markup);
        break;

    // Admin lệnh
    case $text === "/sodu" && $chat_id == $ADMIN_CHAT_ID:
        $stmt = $pdo->query("SELECT SUM(coins) FROM users");
        $total = $stmt->fetchColumn() ?: 0;
        sendMessage($chat_id, "💰 Tổng số dư toàn hệ thống: <b>".number_format($total,0,',','.')." xu</b>");
        break;

   case $isThongBao:
    $msg = trim($m[1]);
    $markup = [
        "inline_keyboard"=>[
            [["text"=>"🚀 Mở Mini App","web_app"=>["url"=>$WEBAPP_URL]]]
        ]
    ];

    // Kiểm tra cờ gửi thông báo
    if(getSetting("thongbao_active","1") !== "1"){
        sendMessage($chat_id,"⛔ Chức năng gửi thông báo đang tạm dừng!");
        break;
    }

    $stmt = $pdo->query("SELECT id FROM users");
    $users = $stmt->fetchAll(PDO::FETCH_COLUMN);

    $batchSize = 20; 
    $i = 0;

    foreach($users as $uid){
        @file_get_contents($API_URL."sendMessage?".http_build_query([
            "chat_id"=>$uid,
            "text"=>"📢 <b>Thông báo:</b>\n\n$msg",
            "parse_mode"=>"HTML",
            "reply_markup"=>json_encode($markup)
        ]));

        $i++;
        if($i % $batchSize == 0) sleep(1); 
    }

    // ❌ Không gửi báo cáo $ok/$fail nữa
    break;


    // Bật/tắt link toàn bộ nhóm
    case $text === "/locklinks" && $chat_id == $ADMIN_CHAT_ID:
        setSetting("allow_links","0");
        sendMessage($chat_id,"🔒 Đã khóa gửi link/@ trong toàn bộ nhóm.");
        break;

    case $text === "/unlocklinks" && $chat_id == $ADMIN_CHAT_ID:
        setSetting("allow_links","1");
        sendMessage($chat_id,"🔓 Đã mở khóa, cho phép gửi link/@ trong toàn bộ nhóm.");
        break;

    default:
        $markup = ["inline_keyboard"=>[[["text"=>"🚀 Mở Mini App","web_app"=>["url"=>$WEBAPP_URL]]]]];
        sendMessage($chat_id, "🎉 Chào mừng đến với TelePet Clicker!\n👉 MiniApp kiếm thưởng, mở rương, giới thiệu bạn bè.", $markup);
}
