<?php 
require_once __DIR__.'/../config.php'; 
?>
<!doctype html>
<html lang="vi" data-theme="dark">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>TelePet Clicker - Rút tiền</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/css/app.css">
  <script src="https://telegram.org/js/telegram-web-app.js"></script>
  <style>
    body { 
      background: radial-gradient(1200px 600px at 20% -20%, #3e1f72, transparent), 
                  radial-gradient(1200px 800px at 120% 20%, #0b6b6e, transparent), 
                  #0c0e14; 
      color: #f3f4f6; 
    }

    #withdraw-history table {
      background: rgba(255, 255, 255, 0.05);
      backdrop-filter: blur(8px);
      border-radius: 12px;
      overflow: hidden;
      width: 100%;
    }

    #withdraw-history th, 
    #withdraw-history td {
      vertical-align: middle;
      text-align: center;
      color: black;
    }

    #withdraw-history tbody tr:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .badge.bg-success { background-color: #22c55e !important; }
    .badge.bg-warning { background-color: #facc15 !important; color: #000; }

  </style>
</head>
<body class="bg-body">

<div id="main-app" class="container py-3">

  <!-- HEADER -->
  <div class="d-flex align-items-center gap-3 mb-3">
    <img src="https://cdn.jsdelivr.net/gh/twitter/twemoji@14.0.2/assets/svg/1f436.svg" width="48" height="48" alt="money">
    <div>
       <h4 class="m-0 fw-bold">TelePet Clicker</h4>
      <small class="text-secondary">Nuôi pet • Đào coin • Câu hỏi vui</small>
    </div>
    <div class="ms-auto text-end">
      <div>Số dư: <span id="coins" class="fw-bold text-warning">0</span> xu</div>
    </div>
  </div>

  <!-- FORM RÚT TIỀN -->
  <h4 class="mb-3">Yêu cầu rút tiền</h4>

  <div class="card glass mb-3">
    <div class="card-body">
      <form id="withdraw-form">

        <!-- Chọn phương thức (radio) -->
        <div class="mb-3">
          <label class="form-label d-block">Chọn phương thức</label>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="method" id="atmRadio" value="ATM" checked>
            <label class="form-check-label" for="atmRadio">
  Ngân hàng
  <span class="badge bg-warning text-dark ms-1">Nhanh</span>
</label>
          </div>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="method" id="momoRadio" value="Momo">
            <label class="form-check-label" for="momoRadio">Ví MoMo</label>
          </div>
        </div>

        <!-- Trường tên ngân hàng (ATM) -->
   <!-- CSS Select2 + theme bootstrap5 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.1.1/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<!-- jQuery + Select2 JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
/* Tinh chỉnh để Select2 trông như input Bootstrap */
.select2-container--bootstrap-5 .select2-selection--single {
  height: calc(1.5em + .75rem + 2px); /* giống chiều cao form-control */
  padding: .375rem .75rem;
  border-radius: .375rem;
  border: 1px solid #ced4da;
  background-color: transparent; /* hoặc #fff nếu bạn dùng nền sáng */
  box-shadow: none;
}
.select2-container--bootstrap-5 .select2-selection__arrow {
  height: calc(1.5em + .75rem + 2px);
  right: .5rem;
}
.select2-container--bootstrap-5 .select2-selection__rendered {
  line-height: 1.5;
  color: inherit;
}
/* Nếu bạn dùng giao diện tối, thay sắc nền / chữ nếu cần */
</style>

<!-- CSS Select2 + theme bootstrap5 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.1.1/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<!-- jQuery + Select2 JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
/* Nền trắng, chữ đen */
.select2-container--bootstrap-5 .select2-selection--single {
  height: calc(1.5em + .75rem + 2px) !important;
  padding: .375rem .75rem !important;
  border-radius: .375rem;
  border: 1px solid #ced4da;
  background-color: #fff !important;  /* nền trắng */
  color: #000 !important;             /* chữ đen */
  box-shadow: none;
}

.select2-container--bootstrap-5 .select2-selection__rendered {
  line-height: 1.5;
  color: #000 !important;
}

.select2-container--bootstrap-5 .select2-selection__arrow {
  height: calc(1.5em + .75rem + 2px);
  right: .5rem;
}

/* Dropdown option */
.select2-container--bootstrap-5 .select2-results__option {
  color: #000 !important;
  background-color: #fff;
}

.select2-container--bootstrap-5 .select2-results__option--highlighted {
  background-color: #e2e2e2 !important;
  color: #000 !important;
}
</style>

<div class="mb-3 bank-field">
  <label class="form-label">Chọn ngân hàng</label>
  <select id="nametk" name="nametk" class="form-control w-100" required>
    <option value="">-- Chọn ngân hàng --</option>
    <option value="Vietcombank">Vietcombank</option>
    <option value="VietinBank">VietinBank</option>
    <option value="Techcombank">Techcombank</option>
    <option value="BIDV">BIDV</option>
    <option value="Agribank">Agribank</option>
    <option value="MBBank">MBBank</option>
    <option value="ACB">ACB</option>
    <option value="Sacombank">Sacombank</option>
    <option value="TPBank">TPBank</option>
    <option value="VPBank">VPBank</option>
    <option value="SCB">SCB</option>
    <option value="OCB">OCB</option>
    <option value="HDBank">HDBank</option>
    <option value="VIB">VIB</option>
    <option value="ShinhanBank">ShinhanBank</option>
    <option value="Eximbank">Eximbank</option>
    <option value="LienVietPostBank">LienVietPostBank</option>
    <option value="NCB">NCB</option>
    <option value="NamABank">NamABank</option>
    <option value="Kienlongbank">Kienlongbank</option>
    <option value="PVcomBank">PVcomBank</option>
    <option value="BacABank">BacABank</option>
    <option value="ABBANK">ABBANK</option>
    <option value="StandardChartered">Standard Chartered</option>
    <option value="HSBC">HSBC</option>
    <option value="MSB">MSB</option>
    <option value="SeABank">SeABank</option>
    <option value="BaoVietBank">BaoVietBank</option>
    <option value="OceanBank">OceanBank</option>
    <option value="SaiGonBank">SaiGonBank</option>
    <option value="KBank">KBank</option>
    <option value="VietABank">VietABank</option>
    <option value="VietBank">VietBank</option>
  </select>
</div>

<script>
$(document).ready(function() {
  $('#nametk').select2({
    theme: 'bootstrap-5',
    placeholder: 'Chọn ngân hàng',
    allowClear: true,
    width: '100%',
    dropdownParent: $('#main-app') // tránh dropdown bị cắt trong container
  });
});
</script>






        <!-- Tên người nhận (cả 2 phương thức) -->
        <div class="mb-3 recipient-field">
          <label class="form-label">Tên người nhận</label>
          <input type="text" id="namebank" class="form-control" placeholder="Nhập tên người nhận" required>
        </div>

        <!-- Số tài khoản / Ví -->
        <div class="mb-3">
          <label class="form-label">Số tài khoản / Ví</label>
          <input type="text" id="account" class="form-control" placeholder="Nhập số tài khoản hoặc số ví" required>
        </div>

        <!-- Số tiền muốn rút -->
        <div class="mb-3">
          <label class="form-label">Số tiền muốn rút (xu)</label>
          <input type="number" id="amount" class="form-control" min="100000" step="100000" placeholder="Tối thiểu 100,000 xu" required>
        </div>

        <!-- Số tiền nhận được tự tính -->
        <div class="mb-3">
          <label class="form-label">Số tiền nhận được (VND)</label>
          <input type="text" id="received" class="form-control" placeholder="0" readonly>
        </div>

        <button class="btn btn-success w-100" type="submit">Gửi yêu cầu</button>

      </form>
    </div>
  </div>

  <!-- LỊCH SỬ RÚT TIỀN -->
  <h5 class="mb-2">Lịch sử rút tiền</h5>
  <div id="withdraw-history" class="small text-secondary">
    <table class="table table-sm table-hover text-white align-middle">
      <thead>
        <tr>
          <th>ID</th>
          <th>Số tiền</th>
          <th>Loại</th>
          <th>Thời gian</th>
          <th>Trạng thái</th>
        </tr>
      </thead>
      <tbody>
        <tr><td colspan="5" class="text-center">Đang tải...</td></tr>
      </tbody>
    </table>
  </div>

</div>

<?php include 'footer.php'; ?>

<script>
const API = 'api.php';

// Lấy dữ liệu Telegram WebApp
function getInitData(){
  const tg = window.Telegram?.WebApp;
  if(!tg) return null;
  return { user: tg.initDataUnsafe?.user || null };
}

// Hàm gọi API
async function api(action, data = {}){
  const init = getInitData();
  const body = new URLSearchParams({ 
    action, 
    init_data: JSON.stringify({ user: init?.user || {} }),
    ...data
  });
  const r = await fetch(API, { method: 'POST', body });
  return r.json();
}

// Cập nhật số dư & lịch sử
async function refreshMe(){
  const r = await api('me');
  if(r.ok){
    document.getElementById('coins').textContent = r.user.coins ?? 0;
    loadHistory();
  }
}

// Load lịch sử rút tiền
async function loadHistory(){
  const r = await api('withdraw_history');
  const tbody = document.querySelector("#withdraw-history tbody");
  if(!r.ok || !r.list?.length){
    tbody.innerHTML = `<tr><td colspan="5" class="text-center">Chưa có giao dịch.</td></tr>`;
    return;
  }
  tbody.innerHTML = r.list.map(w=>`
    <tr>
      <td>${w.id}</td>
      <td>${w.amount}</td>
      <td>${w.method}</td>
      <td>${new Date(w.created_at).toLocaleString('vi-VN')}</td>
      <td><span class="badge ${
        w.status === 'Thành công' ? 'bg-success' :
        w.status === 'Đang xử lý' ? 'bg-warning' :
        'bg-danger'
      }">${w.status}</span></td>
    </tr>
  `).join('');
}


// Ẩn/hiện trường tên ngân hàng dựa trên phương thức
function updateFields() {
  const method = document.querySelector('input[name="method"]:checked').value;
  const bankSelect = document.getElementById('nametk');
  const bankFields = document.querySelectorAll('.bank-field');

  if (method === 'ATM') {
    bankFields.forEach(f => f.style.display = 'block');
    bankSelect.setAttribute('required', 'required');
  } else {
    bankFields.forEach(f => f.style.display = 'none');
    bankSelect.removeAttribute('required');
  }
}

// Khi đổi phương thức
document.querySelectorAll('input[name="method"]').forEach(radio => {
  radio.addEventListener('change', updateFields);
});

// Tính số tiền nhận được
const amountInput = document.getElementById('amount');
const receivedInput = document.getElementById('received');
amountInput.addEventListener('input', () => {
  const amount = parseFloat(amountInput.value) || 0;
  const received = amount * 0.02;
  receivedInput.value = received.toLocaleString('vi-VN');
});

// Submit form
document.getElementById('withdraw-form').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const method = document.querySelector('input[name="method"]:checked').value;
  const account = document.getElementById('account').value.trim();
  const amount = document.getElementById('amount').value;
  const namebank = document.getElementById('namebank').value.trim();
  const nametk = document.getElementById('nametk').value.trim();

  if(!method || !account || !amount || !namebank) {
    alert("⚠️ Vui lòng nhập đủ thông tin!");
    return;
  }

  if(method === 'ATM' && !nametk) {
    alert("⚠️ Vui lòng nhập tên ngân hàng!");
    return;
  }

  const r = await api('withdraw_request', { method, account, amount, namebank, nametk });
  if(r.ok){
    alert("✅ Yêu cầu rút tiền đã được gửi!");
    refreshMe();
    e.target.reset();
    updateFields();
  } else {
    alert("❌ " + (r.error || "Có lỗi xảy ra"));
  }
});

// Khởi tạo khi load trang
document.addEventListener('DOMContentLoaded', () => {
  refreshMe();
  updateFields();
});
</script>

</body>
</html>
