<?php
require_once __DIR__.'/../config.php';
?><!doctype html>
<html lang="vi" data-theme="dark">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>TelePet Clicker</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="../assets/css/app.css">
<script src="https://telegram.org/js/telegram-web-app.js"></script>
<script src="https://sdk.adsgram.ai/js/adsgram.min.js"></script>
<script src="https://sad.adsgram.ai/js/sad.min.js"></script>

<style>
/* Intro screen */
#intro-screen {
  position: fixed;
  inset: 0;
  background: linear-gradient(135deg,#3b82f6,#9333ea);
  color: #fff;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  z-index: 9999;
  text-align: center;
  transition: opacity 1s ease;
}
#intro-screen h1 {
  font-size: 2rem;
  font-weight: bold;
  margin-top: 1rem;
}
#progress-container {
  width: 80%;
  margin-top: 1.5rem;
}
#main-app {
  display: none;
}
</style>
</head>
<body class="bg-body">

<!-- Intro -->
<div id="intro-screen">
  <img src="https://cdn.jsdelivr.net/gh/twitter/twemoji@14.0.2/assets/svg/1f436.svg" width="96" height="96" alt="logo">
  <h1>TelePet Clicker</h1>
  <p>Nuôi pet • Đào coin • Câu hỏi vui</p>
  <div id="progress-container" class="progress">
    <div id="progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-warning" role="progressbar" style="width:0%">0%</div>
  </div>
</div>
<!-- Main App -->
<div id="main-app" class="container py-3">
  <div class="d-flex align-items-center gap-3 mb-3">
    <img src="https://cdn.jsdelivr.net/gh/twitter/twemoji@14.0.2/assets/svg/1f436.svg" width="48" height="48" alt="pet">
    <div>
      <h4 class="m-0 fw-bold">TelePet Clicker</h4>
      <small class="text-secondary">Nuôi pet • Đào coin • Câu hỏi vui</small>
    </div>
    <div class="ms-auto">
      <span id="username" class="badge text-bg-secondary">...</span>
    </div>
  </div>
  
 

  <div class="card glass mb-3">
    <div class="card-body d-flex align-items-center gap-3">
      <div class="pet-wrap">
        <div id="pet" class="pet bounce">🐶</div>
        <div id="pet-level" class="small text-center mt-1">Lv 1</div>
      </div>
      <div class="flex-fill">
        <div class="d-flex justify-content-between mb-1">
          <div><span class="text-secondary"><img src="https://cdn-icons-png.flaticon.com/512/217/217853.png" width="16" height="16" alt="coin"> Coin:</span> <span id="coins" class="fw-bold">0</span></div>
          <div><span class="text-secondary">x</span> <span id="multiplier" class="fw-bold">1</span></div>
        </div>
        <div class="d-grid gap-2">
          <button id="btn-tap" class="btn btn-lg btn-primary rounded-4 shadow">Cho ăn👆</button>
          <div class="d-flex gap-2">
            <button id="btn-boost" class="btn btn-outline-warning flex-fill rounded-4">Thêm lượt cho ăn (Ad)</button>
            <button id="btn-chest" class="btn btn-outline-success flex-fill rounded-4"><img src="https://png.pngtree.com/png-clipart/20240614/original/pngtree-a-treasure-chest-icon-symbol-of-fortune-and-adventure-png-image_15319513.png" width="48" height="48" alt="coin"> <br>Mở rương (Ad)</button>
            
            
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-12 col-md-6">
      <div class="card glass h-100">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <h5 class="m-0">Câu hỏi mỗi ngày</h5>
            <span class="small text-secondary">Đúng nhận coin</span>
          </div>
          <div id="quiz-box">
            <button id="btn-get-quiz" class="btn btn-sm btn-outline-light rounded-4">Lấy câu hỏi</button>
            <div id="quiz" class="mt-2 d-none"></div>
            <div class="mt-2 d-flex gap-2">
              <button id="btn-quiz-skip" class="btn btn-outline-warning btn-sm rounded-4">Bỏ qua câu hỏi (Ad)</button>
              <button id="btn-quiz-double" class="btn btn-outline-success btn-sm rounded-4">Thêm câu hỏi (Ad)</button>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-md-6">
      <div class="card glass h-100">
        <div class="card-body">
          <h5 class="mb-2">Giới thiệu bạn bè</h5>
          <ol class="mb-2">
            <li>Mời 1 bạn mới qua link giới thiệu</li>
            <li>Theo dõi kênh/Xem post (tùy chọn)</li>
          </ol>
          <div class="input-group">
            <input id="ref-link" class="form-control" readonly value="Đang tạo link...">
            <button id="btn-copy" class="btn btn-outline-light">Copy</button>
          </div>
          <small class="text-secondary">Khi bạn giới thiệu thành công và người bạn giới thiệu làm 1 nhiệm vụ bất kì. Bạn sẽ nhận được 20.000 xu và 10% xu từ người bạn giới thiệu kiếm được.</small>
        </div>
      </div>
    </div>
  </div>

  <div class="card glass mt-3">
    <div class="card-body d-flex justify-content-between align-items-center">
      <div>
        <div class="fw-semibold">Điểm danh ngày</div>
        <small class="text-secondary">+<span id="daily-amount">0</span> coin / ngày</small>
      </div>
      <button id="btn-daily" class="btn btn-success rounded-4">Nhận</button>
    </div>
  </div>
  
  <div class="card glass mt-3">
  <div class="card-body">
    <h5 class="mb-2">Nhiệm vụ kiếm xu</h5>
    <adsgram-task 
      id="task1"
      data-block-id="task-14321"  <!-- ⚠️ thay bằng Block ID thật trong Adsgram Dashboard -->
      data-debug="true"
      class="task">
      <p slot="reward" class="task__reward">🪙 100 xu</p>
      <div slot="button" class="task__button btn btn-outline-primary rounded-4">Thực hiện</div>
      <div slot="claim" class="task__button btn btn-success rounded-4">Nhận thưởng</div>
      <div slot="done" class="task__button btn btn-secondary rounded-4">Hoàn thành</div>
    </adsgram-task>
    
    
    <adsgram-task 
      id="task2"
      data-block-id="task-14273"  <!-- ⚠️ thay bằng Block ID thật trong Adsgram Dashboard -->
      data-debug="true"
      class="task">
      <p slot="reward" class="task__reward">🪙 100 xu</p>
      <div slot="button" class="task__button btn btn-outline-primary rounded-4">Thực hiện</div>
      <div slot="claim" class="task__button btn btn-success rounded-4">Nhận thưởng</div>
      <div slot="done" class="task__button btn btn-secondary rounded-4">Hoàn thành</div>
    </adsgram-task>
    
    
    
  </div>
</div>

</div>
<?php include 'footer.php'; ?>
<script>
const API = 'api.php';

// Cấu hình Block IDs từ Adsgram (⚠️ Thay bằng block ID thật từ Adsgram dashboard)
const BLOCK_IDS = {
  boost: '14264',         // ⚠️ Thay bằng block ID thật
  chest: '14274',         // ⚠️ Thay bằng block ID thật
  quiz_skip: '14275',  // ⚠️ Thay bằng block ID thật
  quiz_double: '14276' // ⚠️ Thay bằng block ID thật
};

function getInitData(){
  const tg = window.Telegram?.WebApp;
  if(!tg) return null;
  const user = tg.initDataUnsafe?.user || null;
  let ref = 0;
  try {
    const sp = new URLSearchParams(tg.initData);
    const startapp = sp.get('start_param') || sp.get('startapp');
    if(startapp && /^ref_\d+$/.test(startapp)){ ref = parseInt(startapp.split('_')[1]); }
  } catch(e){}
  return {user, ref};
}

async function api(action, data = {}){
  const init = getInitData();
  const body = new URLSearchParams({ action, init_data: JSON.stringify({ user: init?.user || {} }) });
  if(init && init.ref) body.append('ref', init.ref);
  Object.entries(data).forEach(([k, v]) => body.append(k, v));
  const r = await fetch(API, { method: 'POST', body });
  return r.json();
}

function toast(msg){
  if(window.Telegram?.WebApp?.showPopup){
    window.Telegram.WebApp.showPopup({ title: 'Thông báo', message: msg, buttons: [{ type: 'ok' }] });
  } else {
    alert(msg);
  }
}

function setUserUI(u){
  document.getElementById('username').textContent = u.username ? '@' + u.username : u.name || ('ID ' + u.id);
  document.getElementById('coins').textContent = u.coins;
  document.getElementById('pet-level').textContent = 'Lv ' + u.pet_level;
  document.getElementById('multiplier').textContent = u.multiplier;
  document.getElementById('daily-amount').textContent = u.daily_reward;
  const botUsername = "kiemtien6789_bot";
const miniAppName = "MiniApp"; // tên Mini‑App đã đăng ký
const ref = `https://t.me/${botUsername}/${miniAppName}?startapp=ref_${u.id}`;
document.getElementById('ref-link').value = ref;

}

async function refreshMe(){
  const r = await api('me');
  if(r.ok) setUserUI(r.user);
}


// Format thời gian dạng MM:SS
function formatTime(sec) {
  const m = Math.floor(sec / 60);
  const s = sec % 60;
  return `${m}:${s < 10 ? '0' : ''}${s}`;
}

function startAdCooldownTimers() {
  const cooldownSeconds = 600; // 10 phút = 600 giây

  const BUTTONS = {
    boost: { id: 'btn-boost', label: 'Thêm lượt cho ăn (Ad)' },
    chest: { id: 'btn-chest', label: 'Mở rương (Ad)' },
    quiz_skip: { id: 'btn-quiz-skip', label: 'Bỏ qua câu hỏi (Ad)' },
    quiz_double: { id: 'btn-quiz-double', label: 'Thêm câu hỏi (Ad)' },
  };

  Object.entries(BUTTONS).forEach(([type, { id, label }]) => {
    const btn = document.getElementById(id);
    if (!btn) return;

    const lastTime = parseInt(localStorage.getItem(`ad_last_time_${type}`)) || 0;
    const elapsed = Math.floor(Date.now() / 1000) - lastTime;
    const remaining = cooldownSeconds - elapsed;

    if (remaining > 0) {
      btn.disabled = true;
      let secs = remaining;
      const interval = setInterval(() => {
        if (secs <= 0) {
          btn.disabled = false;
          btn.innerText = label;
          clearInterval(interval);
        } else {
          const m = String(Math.floor(secs / 60)).padStart(2, '0');
          const s = String(secs % 60).padStart(2, '0');
          btn.innerText = `⏳ ${m}:${s}`;
          secs--;
        }
      }, 1000);
    } else {
      btn.disabled = false;
      btn.innerText = label;
    }
  });
}


// ✅ Viết lại hoàn toàn: Hàm mở quảng cáo bằng block_id
async function openRewarded(type) {
  const cooldown = 600; // 10 phút = 600 giây
  const key = 'ads_last_' + type;

  const last = parseInt(localStorage.getItem(key) || 0);
  const now = Math.floor(Date.now() / 1000);
  const diff = now - last;

  if (diff < cooldown) {
    toast('⏳ Vui lòng chờ ' + formatTime(cooldown - diff) + ' nữa để xem quảng cáo tiếp');
    return;
  }

  const blockId = BLOCK_IDS[type];
  if (!blockId) {
    toast('Không tìm thấy quảng cáo cho loại: ' + type);
    return;
  }

  if (!window.Adsgram || !window.Adsgram.init) {
    toast('Adsgram chưa sẵn sàng');
    return;
  }

  toast('Đang tải quảng cáo...');

  try {
    const ad = window.Adsgram.init({ blockId });
    const result = await ad.show();

    if (result.done) {
      localStorage.setItem(key, now); // ✅ lưu lại thời gian sau khi xem

      switch (type) {
       case 'boost':
  const tok = await api('ads_token', { type });
  await api('start_boost', { ads_ok: tok.token });
  addTapAttempt(); // ✅ thêm 1 lượt
  break;
        case 'chest':
          const res = await api('open_chest');
          toast('🎁 Nhận được +' + res.reward + ' coin từ rương!');
          break;
        case 'quiz_skip':
          toast('✅ Đã bỏ qua câu hỏi. Thử câu khác!');
          document.getElementById('btn-get-quiz').click();
          break;
        case 'quiz_double':
  await addQuizAttempt();
  break;

      }

localStorage.setItem(`ad_last_time_${type}`, Math.floor(Date.now() / 1000));
startAdCooldownTimers(); // 👈 Gọi lại để áp cooldown

      await refreshMe();
    } else {
      toast('😕 Bạn chưa hoàn thành quảng cáo');
    }

  } catch (err) {
    console.error('[Adsgram] Lỗi khi hiển thị quảng cáo:', err);
    toast('❌ Không thể hiển thị quảng cáo. Thử lại sau.');
  }
}




document.addEventListener('DOMContentLoaded', ()=>{
  window.Telegram?.WebApp?.ready();
  refreshMe();

  // ✅ cập nhật UI số lượt đào còn lại khi load
  updateTapUI(); 
  startAdCooldownTimers();

  // Xử lý click nút Đào 👆
  document.getElementById('btn-tap').addEventListener('click', async()=>{
    let left = getTapAttempts();
    if(left <= 0){
      toast("⛏️ Bạn đã hết lượt cho ăn hôm nay, hãy xem quảng cáo để thêm lượt!");
      return;
    }

    const r = await api('tap');
    if(r.ok){
      const c = document.getElementById('coins');
      c.textContent = (parseInt(c.textContent) || 0) + r.added;

      const pet = document.getElementById('pet');
      pet.classList.add('pop');
      setTimeout(() => pet.classList.remove('pop'), 180);

      // ✅ Trừ 1 lượt
      setTapAttempts(left - 1);
      updateTapUI();
    }
    refreshMe();
startAdCooldownTimers();


(async () => {
  const init = getInitData();
  console.log('Init:', init);
  if(init?.ref){
    const res = await fetch('api.php', {
      method: 'POST',
      body: new URLSearchParams({ action: 'referral', ref: init.ref })
    });
    const json = await res.json();
    console.log('Referral result:', json);
  }
})();

const taskEl = document.getElementById("task1");

  taskEl.addEventListener("claim", async (e) => {
    console.log("Task claim event:", e.detail);

    // gửi về server
    const res = await fetch("api.php?action=task_claim", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ blockId: e.detail.blockId })
    });

    const data = await res.json();

    if (data.ok) {
      alert(`Bạn đã nhận ${data.reward} xu 🎉`);
    } else {
      alert("Có lỗi: " + data.error);
    }
  });


  });

  // ✅ Gọi openRewarded với block_id tương ứng
  document.getElementById('btn-boost').addEventListener('click', async()=>{
    await openRewarded('boost');
  });

  document.getElementById('btn-chest').addEventListener('click', async()=>{
    await openRewarded('chest');
  });

  document.getElementById('btn-quiz-skip').addEventListener('click', async()=>{
    await openRewarded('quiz_skip');
  });

  document.getElementById('btn-quiz-double').addEventListener('click', async()=>{
    await openRewarded('quiz_double');
  });

  document.getElementById('btn-copy').addEventListener('click', ()=>{
    const inp = document.getElementById('ref-link');
    inp.select(); inp.setSelectionRange(0,99999); document.execCommand('copy');
    toast('Đã copy link giới thiệu');
  });

  document.getElementById('btn-daily').addEventListener('click', async()=>{
    const r = await api('daily_claim');
    if(r.ok){
      toast(r.claimed ? ('Nhận +' + r.amount + ' coin') : 'Bạn đã nhận hôm nay rồi');
      refreshMe();
    }
  });
  
  function getInitData() {
  const tg = window.Telegram?.WebApp;
  if (!tg) return null;

  const user = tg.initDataUnsafe?.user || null;
  let ref = 0;

  try {
    // Lấy referral từ start_param (startapp)
    const startParam = tg.initDataUnsafe?.start_param || "";
    if (/^ref_\d+$/.test(startParam)) {
      ref = parseInt(startParam.split('_')[1]);
    }
  } catch (e) {}

  return { user, ref };
}


document.getElementById('btn-get-quiz').addEventListener('click', async()=>{
  const attempts = getQuizAttempts();
  if(attempts <= 0){
    const box = document.getElementById('quiz');
    box.classList.remove('d-none');
    box.textContent = 'Hôm nay bạn đã trả lời hết câu hỏi rồi, hãy nhấn " thêm câu hỏi " hoặc quay lại ngày mai nhé!';
    return;
  }

  const r = await api('quiz_get');
  const box = document.getElementById('quiz');
  box.innerHTML = '';
  if(r.ok && r.quiz){
    box.classList.remove('d-none');
    const q = r.quiz;
    const qEl = document.createElement('div');
    qEl.innerHTML = '<div class="fw-semibold mb-2">' + q.question + '</div>';
    
    q.options.forEach((opt, i)=>{
      const btn = document.createElement('button');
      btn.className = 'btn btn-outline-light w-100 mb-2 rounded-4';
      btn.textContent = opt;
      btn.onclick = async()=> {
        const allBtns = box.querySelectorAll('button');
        allBtns.forEach(b => b.disabled = true);

        const rr = await api('quiz_answer', { quiz_id: q.id, option: i });
        if(rr.ok){
          toast(rr.correct ? ('🎉 Đúng! +' + rr.reward + ' coin') : '❌ Sai mất rồi');
          refreshMe();
          // ✅ trừ 1 lượt
          setQuizAttempts(getQuizAttempts() - 1);
        }
      };
      qEl.appendChild(btn);
    });
    box.appendChild(qEl);
  } else {
    box.classList.remove('d-none');
    box.textContent = 'Không có câu hỏi nào!';
  }
});



});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>




<script>
// ---- Quản lý lượt quiz mỗi ngày ----
function getTodayKey() {
  const d = new Date();
  return d.toISOString().slice(0,10); // YYYY-MM-DD
}

function getQuizAttempts() {
  const key = 'quiz_attempts_' + getTodayKey();
  return parseInt(localStorage.getItem(key) || "1"); // mặc định 1 lượt/ngày
}

function setQuizAttempts(val) {
  const key = 'quiz_attempts_' + getTodayKey();
  localStorage.setItem(key, val);
}

// Khi ấn Nhân đôi (Ad) thì +1 lượt
async function addQuizAttempt() {
  const now = getQuizAttempts();
  setQuizAttempts(now + 1);
  toast('🎁 Bạn đã nhận thêm 1 câu hỏi!');
}
</script>

<script>
// ---- Quản lý lượt đào mỗi ngày ----
function getTodayKey() {
  const d = new Date();
  return d.toISOString().slice(0,10); // YYYY-MM-DD
}

function getTapAttempts() {
  const key = 'tap_attempts_' + getTodayKey();
  return parseInt(localStorage.getItem(key) || "1"); // mặc định 1 lượt/ngày
}

function setTapAttempts(val) {
  const key = 'tap_attempts_' + getTodayKey();
  localStorage.setItem(key, val);
}

function updateTapUI(){
  const btn = document.getElementById('btn-tap');
  const left = getTapAttempts();
  if(left <= 0){
    btn.disabled = true;
    btn.innerText = "Cho ăn";
  } else {
    btn.disabled = false;
    btn.innerText = "Cho ăn 👆 ("+left+" lượt)";
  }
}

// Khi ấn thêm lượt (Ad) thì +1 lượt
async function addTapAttempt() {
  const now = getTapAttempts();
  setTapAttempts(now + 1);
  toast('🎁 Bạn đã nhận thêm 1 lượt cho ăn!');
  updateTapUI();
}
</script>




<script>
const intro = document.getElementById("intro-screen");
const app = document.getElementById("main-app");
const bar = document.getElementById("progress-bar");

// Nếu đã có session thì bỏ qua intro
if (sessionStorage.getItem("intro_seen")) {
  intro.style.display = "none";
  app.style.display = "block";
} else {
  let progress = 0;
  let interval = setInterval(() => {
    progress += 2; // tăng 2% mỗi 100ms → 5 giây = 100%
    if (progress > 100) progress = 100;
    bar.style.width = progress + "%";
    bar.innerText = progress + "%";

    if (progress >= 100) {
      clearInterval(interval);
      intro.style.opacity = 0;
      setTimeout(() => {
        intro.style.display = "none";
        app.style.display = "block";
        sessionStorage.setItem("intro_seen", "1"); // ✅ chỉ sống trong 1 phiên
      }, 1000);
    }
  }, 100);
}
</script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>