<?php 
require_once __DIR__.'/../config.php'; 
?>
<!doctype html>
<html lang="vi" data-theme="dark">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>TelePet Clicker - Giới thiệu bạn bè</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/css/app.css">
  <script src="https://telegram.org/js/telegram-web-app.js"></script>
  <style>
  body { 
    background: radial-gradient(1200px 600px at 20% -20%, #3e1f72, transparent), 
                radial-gradient(1200px 800px at 120% 20%, #0b6b6e, transparent), 
                #0c0e14; 
    color: #f3f4f6; 
  }
  </style>
</head>
<body class="bg-body">

<div id="main-app" class="container py-3">

  <!-- HEADER -->
  <div class="d-flex align-items-center gap-3 mb-3">
    <img src="https://cdn.jsdelivr.net/gh/twitter/twemoji@14.0.2/assets/svg/1f436.svg" width="48" height="48" alt="pet">
    <div>
      <h4 class="m-0 fw-bold">TelePet Clicker</h4>
      <small class="text-secondary">Nuôi pet • Đào coin • Câu hỏi vui</small>
    </div>
    <div class="ms-auto">
      <span id="username" class="badge text-bg-secondary">...</span>
    </div>
  </div>

  <!-- NHIỆM VỤ XÃ HỘI -->
  <h4 class="mb-3">Giới thiệu bạn bè</h4>
  
  <div class="card glass mb-3">
    <div class="card-body">
      <h5 class="mb-2">Theo dõi kênh Telegram</h5>
      <a href="https://t.me/telepet_kiemtien" target="_blank" class="btn btn-primary">Tham gia ngay</a>
    </div>
  </div>
  
  <!--<div class="card glass mb-3">-->
  <!--  <div class="card-body">-->
  <!--    <h5 class="mb-2">Tham gia nhóm Zalo</h5>-->
  <!--    <a href="https://zalo.me/g/lknmsr138" target="_blank" class="btn btn-primary">Tham gia ngay</a>-->
  <!--  </div>-->
  <!--</div>-->
  
  <div class="card glass mb-3">
    <div class="card-body">
      <h5 class="mb-2">Mời bạn bè</h5>
      <p>Khi bạn giới thiệu thành công và người bạn giới thiệu làm 3 nhiệm vụ bất kì. Bạn sẽ nhận được 20.000 xu và 10% xu từ người bạn giới thiệu kiếm được.</p>
      <div class="input-group">
        <input id="ref-link" class="form-control" readonly value="Đang tạo link...">
        <button id="btn-copy" class="btn btn-outline-light">Copy</button>
         <button id="btn-share" class="btn btn-outline-success">Chia sẻ</button>
      </div>
      
      <div class="mt-3" id="social-info">
        👥 Đã mời: <span id="referrals">0</span> bạn<br>
        💰 Bạn đã kiếm được: <span id="ref-earnings">0</span> xu
      </div>
    </div>
  </div>

</div>

<?php include 'footer.php'; ?>

<script>
const API = 'api.php';

function getInitData(){
  const tg = window.Telegram?.WebApp;
  if(!tg) return null;
  return { user: tg.initDataUnsafe?.user || null };
}



async function api(action){
  const init = getInitData();
  const body = new URLSearchParams({ 
    action, 
    init_data: JSON.stringify({ user: init?.user || {} }) 
  });
  const r = await fetch(API, { method: 'POST', body });
  return r.json();
}

function setUserUI(u){
  document.getElementById('username').textContent = u.name || 'Ẩn danh';
  const botUsername = "kiemtien6789_bot"; // ⚠️ sửa theo bot của bạn
  const miniAppName = "MiniApp";          // ⚠️ sửa theo MiniApp của bạn
  const ref = `https://t.me/${botUsername}/${miniAppName}?startapp=ref_${u.id}`;
  document.getElementById('ref-link').value = ref;
  document.getElementById('referrals').textContent = u.referrals ?? 0;
  document.getElementById('ref-earnings').textContent = u.ref_earnings ?? 0;
}

async function refreshMe(){
  const r = await api('me');
  if(r.ok) setUserUI(r.user);
}

document.addEventListener('DOMContentLoaded', ()=>{
  refreshMe();
  document.getElementById('btn-copy').addEventListener('click', ()=>{
    const inp = document.getElementById('ref-link');
    inp.select(); inp.setSelectionRange(0, 99999);
    document.execCommand('copy');
    alert("✅ Đã copy link giới thiệu!");
  });
  
  document.getElementById('btn-share').addEventListener('click', ()=>{
  const link = document.getElementById('ref-link').value;
  const shareText = `🎉 Chào mừng bạn đến với TelePet Clicker!\n\n✨ TelePet MiniApp Kiếm Tiền Hoàn Toàn Miễn Phí\n👉 Nuôi Pet - Trả lời câu hỏi - Điểm danh - Mở rương kiếm tiền\n💰 Min rút chỉ 2.000 vnđ,\n✔️ Hỗ trợ tất cả các ngân hàng,\n🎉 Tham gia ngay.\n\n`;
  
  if (navigator.share) {
    navigator.share({
      title: 'TelePet Clicker',
      text: shareText,
      url: link
    }).then(() => {
      console.log('Link đã được chia sẻ thành công!');
    }).catch(console.error);
  } else {
    const tgShare = `https://t.me/share/url?url=${encodeURIComponent(link)}&text=${encodeURIComponent(shareText)}`;
    window.open(tgShare, '_blank');
  }
});

  
});
</script>

</body>
</html>
