<?php
// index.php - Game-style UI wrapper that preserves original functionality by linking to existing pages.
// It opens existing functional pages (nhiemvu.php, moi-ban-be.php, rut-tien.php, bxh.php) in modals/iframes so backend logic is unchanged.
header('Content-Type: text/html; charset=utf-8');
// try include auth to populate $user if available
if (file_exists(__DIR__ . '/../includes/auth.php')) {
    @include __DIR__ . '/../includes/auth.php';
}
// page title
$page_title = 'Trang chủ - Cây Vàng (Game UI)';
include __DIR__ . '/head.php';
?>
<style>
/* small helper to ensure iframe modal full height */
#modalFrame { width:100%; height:70vh; border:0; border-radius:10px; }
.modal-backdrop.show { opacity: 0.6; }
</style>

<div class="hero-card">
  <div class="hero-left">
    <div class="hero-coin">🌳 <span style="font-size:22px;font-weight:800;margin-left:8px">Cây Vàng</span></div>
    <div style="margin-top:8px;font-size:14px">Chào <?= isset($user['name']) ? htmlspecialchars($user['name']) : 'Người chơi' ?>, thu thập coin, hoàn thành nhiệm vụ và chăm sóc cây của bạn!</div>
    <div class="small-note">Số dư của bạn: <strong id="balanceTop"><?= isset($user['balance']) ? $user['balance'] : 0 ?></strong> 🪙</div>
    <div style="margin-top:12px; display:flex; gap:8px; flex-wrap:wrap;">
      <button class="btn-game" onclick="openModal('choan','Cho ăn', 'nhiemvu.php?mode=feed')">Cho ăn 🌾</button>
      <button class="btn-game" onclick="openModal('cauhoi','Trả lời câu hỏi','nhiemvu.php?mode=quiz')">Trả lời câu hỏi ❓</button>
      <button class="btn-game" onclick="openModal('diemdanh','Điểm danh','nhiemvu.php?mode=checkin')">Điểm danh 📅</button>
    </div>
  </div>
  <div style="width:120px;display:flex;align-items:center;justify-content:center">
    <div class="logo" style="width:110px;height:110px;font-size:46px;border-radius:16px">🪙</div>
  </div>
</div>

<!-- Actions grid linking to existing pages in modal to preserve logic -->
<div class="action-grid">
  <div class="card-action" onclick="openModal('nhiemvu','Nhiệm vụ','nhiemvu.php')">
    <span class="emoji">🎁</span>
    <div class="fw-bold">Nhiệm vụ</div>
    <div class="small-note">Hoàn thành nhiệm vụ nhận thưởng</div>
  </div>
  <div class="card-action" onclick="openModal('moiruong','Mở rương','nhiemvu.php?mode=chest')">
    <span class="emoji">🎲</span>
    <div class="fw-bold">Mở rương</div>
    <div class="small-note">Mở rương may mắn hàng ngày</div>
  </div>
  <div class="card-action" onclick="openModal('moibanbe','Mời bạn bè','moi-ban-be.php')">
    <span class="emoji">👥</span>
    <div class="fw-bold">Mời bạn bè</div>
    <div class="small-note">Nhận thưởng khi bạn bè tham gia</div>
  </div>
  <div class="card-action" onclick="openModal('ruttien','Rút tiền','rut-tien.php')">
    <span class="emoji">💰</span>
    <div class="fw-bold">Rút tiền</div>
    <div class="small-note">Yêu cầu rút tiền nhanh chóng</div>
  </div>
</div>

<!-- Leaderboard and extra actions -->
<div style="margin-top:16px" class="hero-card">
  <div style="flex:1">
    <div class="fw-bold">🏆 Bảng xếp hạng</div>
    <div class="small-note">Xem top người chơi và thứ hạng của bạn.</div>
  </div>
  <div style="display:flex;gap:8px;align-items:center">
    <button class="btn-game" onclick="openModal('bxh','BXH','bxh.php')">Xem BXH</button>
  </div>
</div>

<!-- Hidden modal to load existing pages preserving backend -->
<div class="modal" tabindex="-1" id="gameModal">
  <div class="modal-dialog modal-fullscreen-sm-down modal-lg modal-dialog-centered">
    <div class="modal-content" style="background:transparent;border:none;">
      <div class="modal-header" style="border:none">
        <h5 class="modal-title" id="modalTitle" style="color:#fff"></h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" style="background: linear-gradient(180deg, rgba(255,255,255,0.02), rgba(255,255,255,0.01)); padding:12px; border-radius:12px;">
        <iframe id="modalFrame" src="" allow="clipboard-read; clipboard-write"></iframe>
      </div>
    </div>
  </div>
</div>

<script>
function openModal(id, title, url){
  const frame = document.getElementById('modalFrame');
  const modalTitle = document.getElementById('modalTitle');
  frame.src = url;
  modalTitle.textContent = title;
  var modal = new bootstrap.Modal(document.getElementById('gameModal'), {backdrop:true});
  modal.show();
}
// update balance display from server periodically (optional)
function refreshBalance(){
  // try to fetch from api.php if exists
  fetch('api.php?action=balance').then(r=>r.json()).then(j=>{
    if(j && j.balance !== undefined){
      document.getElementById('balanceTop').textContent = j.balance;
      const b = document.getElementById('userBalance');
      if(b) b.textContent = j.balance;
    }
  }).catch(e=>{});
}
// refresh every 20s
setInterval(refreshBalance, 20000);
</script>

<?php include __DIR__ . '/footer.php'; ?>