<?php
// ddos_protect.php
session_start();

// Thời gian giới hạn (giây)
$time_limit = 1; // 1 giây
// Số request tối đa trong $time_limit
$max_requests = 5;

if (!isset($_SESSION['ddos'])) {
    $_SESSION['ddos'] = [];
}

// Lưu lịch sử truy cập
$_SESSION['ddos'][] = microtime(true);

// Xóa request cũ quá time_limit
$_SESSION['ddos'] = array_filter($_SESSION['ddos'], function($t) use ($time_limit){
    return $t > microtime(true) - $time_limit;
});

// Nếu vượt quá giới hạn
if (count($_SESSION['ddos']) > $max_requests) {
    http_response_code(429);
    die("⛔ Quá nhiều request, vui lòng thử lại sau.");
}
