<?php
header('Content-Type: application/json');
require_once __DIR__.'/../includes/functions.php';
require_once __DIR__.'/../includes/auth.php';

$action = $_GET['action'] ?? $_POST['action'] ?? '';
$ref = intval($_GET['ref'] ?? $_POST['ref'] ?? 0);
$tg_user = tg_user_from_init();
if(!$tg_user){ json_err('Missing init_data (Telegram WebApp)'); }

$user = upsert_user($pdo, $tg_user, $ref);
$uid = intval($user['id']);

function add_referral_bonus($pdo, $user_id, $gain) {
    // Lấy referrer từ cột referred_by
    $st = $pdo->prepare("SELECT referred_by, first_ref_bonus, dieukien FROM users WHERE id=? LIMIT 1");
    $st->execute([$user_id]);
    $row = $st->fetch(PDO::FETCH_ASSOC);

    if($row && $row['referred_by']){
        $ref = $row['referred_by'];

        // ✅ Thưởng 10% mỗi lần
        $bonus = intval($gain * 0.1);
        if($bonus > 0){
            $upd = $pdo->prepare("UPDATE users SET coins = coins + ?, tongcoin = tongcoin + ? WHERE id=?");
            $upd->execute([$bonus, $bonus, $ref]);
            
            $upd4 = $pdo->prepare("UPDATE users SET dieukien = dieukien + 1 WHERE id=?");
            $upd4->execute([$user_id]);
        }

        // ✅ Thưởng 20k chỉ lần đầu
        if ($row['first_ref_bonus'] == 0 && $row['dieukien'] == 3 ) {
            $upd2 = $pdo->prepare("UPDATE users SET coins = coins + 20000, tongcoin = tongcoin + 20000 WHERE id=?");
            $upd2->execute([$ref]);

            // Đánh dấu đã nhận
            $upd3 = $pdo->prepare("UPDATE users SET first_ref_bonus = 1 WHERE id=?");
            $upd3->execute([$user_id]);
        }
    }
}



    
    
switch($action){
    
    case 'rank':
    $st = $pdo->query("SELECT id, username as name, coins FROM users ORDER BY coins DESC LIMIT 20");
    $list = $st->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['ok'=>true,'list'=>$list]);
    break;
    
     case 'task_claim':
    $json = json_decode(file_get_contents("php://input"), true);
    $blockId = $json['blockId'] ?? '';

    // mapping task -> reward
    $tasks = [
        'task-14321' => 100,
        'task-14273' => 200
    ];

    if (isset($tasks[$blockId])) {
        $reward = $tasks[$blockId];

        $pdo->prepare("UPDATE users SET coins = coins + ? WHERE id=?")
            ->execute([$reward, $me['id']]);

        echo json_encode(['ok'=>true, 'reward'=>$reward]);
    } else {
        echo json_encode(['ok'=>false, 'error'=>'Task không hợp lệ']);
    }
    break;


    
    
    
      case 'withdraw_request':
        $method  = trim($_POST['method'] ?? '');
        $account = trim($_POST['account'] ?? '');
        $amount  = intval($_POST['amount'] ?? 0);
        $namebank = trim($_POST['namebank'] ?? '');
        $nametk   = trim($_POST['nametk'] ?? '');
        $vnd      = $amount * 0.02;

if($amount < 100000){
        json_err('Tối thiểu 100000 xu để rút');
    }
    if($amount > $user['coins']){
        json_err('Không đủ xu để rút');
    }
        if(!$method || !$account || !$amount) json_error("Vui lòng nhập đủ thông tin");
        if($method==='ATM' && !$nametk) json_error("Vui lòng nhập tên ngân hàng!");
        
        $pdo->prepare("UPDATE users SET coins = coins - ? WHERE id=?")
        ->execute([$amount, $uid]);
    $user['coins'] -= $amount;


        // Lưu vào DB
        $stmt = $pdo->prepare("INSERT INTO withdraws (user_id, method, account, amount, status, created_at, namebank, nametk, vnd) VALUES (?, ?, ?, ?, 'Đang xử lý', NOW(), ?, ?, ?)");
        $stmt->execute([$uid, $method, $account, $amount, $namebank, $nametk, $vnd]);

        $id = $pdo->lastInsertId();

        // Gửi Telegram admin
        $text = "📤 Yêu cầu rút tiền mới\n";
        $text .= "ID: $id\nUser: $uid\nSố tiền: ".number_format($amount,0,',','.')." xu (~".number_format($vnd,0,',','.')." VND)\nPhương thức: $method\nTài khoản: $account\nNgân hàng: $nametk\nTên nhận: $namebank\nTrạng thái: Đang xử lý\n";
        if($nametk != null){
        $qrUrl = "https://img.vietqr.io/image/$nametk-$account-compact.jpg?amount=$vnd";
        $text .= "🖼 QR Thanh toán:\n$qrUrl";
        
        }

        $buttons = [
            [
                ["text"=>"✅ Duyệt","callback_data"=>"approve_$id"],
                ["text"=>"❌ Hủy","callback_data"=>"cancel_$id"]
            ]
        ];

        file_get_contents("https://api.telegram.org/bot8308174105:AAHNpQ8KRuHzcxvDRwOf26geva7ZpHaocis/sendMessage?" . http_build_query([
            'chat_id'=>7287969285,
            'text'=>$text,
            'reply_markup'=>json_encode(['inline_keyboard'=>$buttons])
        ]));

        json_ok();
    break;

        
        

    case 'withdraw_history':
        $st = $pdo->prepare("SELECT * FROM withdraws WHERE user_id=? ORDER BY id DESC LIMIT 20");
        $st->execute([$uid]);
        $rows = $st->fetchAll(PDO::FETCH_ASSOC);

        $list = [];
        foreach($rows as $r){
            $list[] = [
                'id'        => $r['id'],
                'method'    => $r['method'],
                'account'   => $r['account'],
                'amount'    =>  number_format($r['vnd']),
                'nametk'   => $r['nametk'],
                'namebank'   => $r['namebank'],
                'status'    => $r['status'],
                'created_at'=> $r['created_at']
            ];
        }
        json_ok(['list'=>$list]);
        break;

    
    
   case 'referral':
    if ($ref > 0 && $uid != $ref) {
        $st = $pdo->prepare("SELECT 1 FROM referrals WHERE referred_id=? LIMIT 1");
        $st->execute([$uid]);
        if (!$st->fetch()) {
            $ins = $pdo->prepare("INSERT INTO referrals (referrer_id, referred_id, created_at) VALUES (?,?,NOW())");
            $ins->execute([$ref,$uid]);

            $upd = $pdo->prepare("UPDATE users SET coins = coins + 1, tongcoin = tongcoin + 1 WHERE id=?");
            $upd->execute([$ref]);

            json_ok(['msg'=>'Referral thành công, người giới thiệu nhận 1 coin']);
        } else {
            json_ok(['msg'=>'Referral đã được ghi nhận trước đó']);
        }
    } else {
        json_err('Referral không hợp lệ');
    }
    break;
    
    


    // case 'me':
    //     $user = user_get($pdo,$uid);
    //     $mult = current_multiplier($user);
    //     json_ok(['user'=>[
    //         'id'=>$user['id'],
    //         'name'=>$user['name'],
    //         'username'=>$user['username'],
    //         'coins'=>intval($user['coins']),
    //         'pet_level'=>intval($user['pet_level']),
    //         'boost_until'=>intval($user['boost_until']),
    //         'multiplier'=>$mult,
    //         'daily_reward'=>DAILY_REWARD
    //     ]]);
    case 'me':
    $user = user_get($pdo,$uid);
    $mult = current_multiplier($user);

    // Đếm số người mà user này đã mời
    $st = $pdo->prepare("SELECT COUNT(*) FROM users WHERE referred_by = ?");
    $st->execute([$user['id']]);
    $referrals = (int)$st->fetchColumn();

    // Nếu bạn có cột coinref hoặc ref_earnings thì lấy luôn, còn không thì cho = 0
    $earnings = isset($user['tongcoin']) ? number_format($user['tongcoin']) : "0";

    json_ok(['user'=>[
        'id' => $user['id'],
        'name' => $user['name'],
        'username' => $user['username'],
        'coins' => intval($user['coins']),
        'pet_level' => intval($user['pet_level']),
        'boost_until' => intval($user['boost_until']),
        'multiplier' => $mult,
        'daily_reward' => DAILY_REWARD,
        'referrals' => $referrals,
        'ref_earnings' => $earnings
    ]]);
    break;

    // case 'tap':
    //     $user = user_get($pdo,$uid);
    //     $gain = BASE_RATE * current_multiplier($user);
    //     add_coins($pdo,$uid,$gain,'tap');
    //     add_referral_bonus($pdo,$uid,$gain); // ✅ cộng 10% cho referrer
    //     json_ok(['added'=>$gain]);
    case 'tap':
    // Đếm số lượt tap trong ngày của user
    $st = $pdo->prepare("SELECT COUNT(*) FROM coin_logs WHERE user_id=? AND reason='tap' AND DATE(created_at)=CURDATE()");
    $st->execute([$uid]);
    $tap_count = intval($st->fetchColumn());

    if ($tap_count >= 10) {
        json_err('Bạn đã hết lượt tap trong ngày');
    }

    // Nếu còn lượt thì cho tap
    $user = user_get($pdo,$uid);
    $gain = BASE_RATE * current_multiplier($user);

    // Cộng coin + lưu log (hàm add_coins bạn đã có sẵn rồi cũng insert vào coin_logs)
    add_coins($pdo,$uid,$gain,'tap');
    add_referral_bonus($pdo,$uid,$gain);

    json_ok([
        'added' => $gain,
        'left'  => 10 - ($tap_count + 1) // số lượt còn lại
    ]);
    break;

    // case 'open_chest':
    //     $reward = random_chest();
    //     add_coins($pdo,$uid,$reward,'chest');
    //     add_referral_bonus($pdo,$uid,$reward); // ✅ cộng 10% cho referrer
    //     json_ok(['reward'=>$reward]);
    case 'open_chest':
    // Giới hạn 5 lần mở rương / ngày
    $st = $pdo->prepare("SELECT COUNT(*) FROM coin_logs WHERE user_id=? AND reason='chest' AND DATE(created_at)=CURDATE()");
    $st->execute([$uid]);
    $chest_count = intval($st->fetchColumn());

    if ($chest_count >= 10) {
        json_err('Bạn đã hết lượt mở rương trong ngày');
    }

    // Nếu còn lượt thì mở
    $reward = random_chest();

    add_coins($pdo,$uid,$reward,'chest');
    add_referral_bonus($pdo,$uid,$reward);

    json_ok([
        'reward' => $reward,
        'left'   => 10 - ($chest_count + 1) // số lượt còn lại
    ]);
    break;

    case 'start_boost':
        // Should only be called after rewarded ad success. Client provides signed token 'ads_ok'
        $tok = $_POST['ads_ok'] ?? '';
        $data = verify_token($tok);
        if(!$data || ($data['uid']??0)!=$uid || ($data['type']??'')!=='boost'){ json_err('Invalid ad token',403); }
        $until = start_boost($pdo,$uid);
        json_ok(['boost_until'=>$until]);
    case 'quiz_get':
        // Get random unanswered quiz for today
        $st = $pdo->prepare("SELECT q.* FROM quizzes q 
            WHERE NOT EXISTS(SELECT 1 FROM quiz_answers a WHERE a.user_id=? AND a.quiz_id=q.id AND DATE(a.created_at)=CURDATE())
            ORDER BY RAND() LIMIT 1");
        $st->execute([$uid]);
        $q = $st->fetch();
        if(!$q) json_ok(['quiz'=>null]);
        $quiz = ['id'=>$q['id'],'question'=>$q['question'],'options'=>json_decode($q['options'],true)];
        json_ok(['quiz'=>$quiz]);
    case 'quiz_answer':
        $qid = intval($_POST['quiz_id'] ?? 0);
        $opt = intval($_POST['option'] ?? -1);
        $q = $pdo->prepare("SELECT * FROM quizzes WHERE id=?"); $q->execute([$qid]); $q=$q->fetch();
        if(!$q) json_err('Quiz not found',404);
        $correct = intval($q['correct']);
        $reward = ($opt==$correct)? intval($q['reward']) : 0;
        $pdo->prepare("INSERT INTO quiz_answers (user_id, quiz_id, choice, correct, created_at) VALUES (?,?,?,?,NOW())")
            ->execute([$uid,$qid,$opt, ($opt==$correct?1:0)]);
        if($reward>0) add_coins($pdo,$uid,$reward,'quiz');
        add_referral_bonus($pdo,$uid,$reward); // ✅ cộng 10% cho referrer
        json_ok(['correct'=>($opt==$correct), 'reward'=>$reward]);
    case 'daily_claim':
        $ok = grant_daily($pdo,$uid);
        json_ok(['claimed'=>$ok, 'amount'=> $ok? DAILY_REWARD : 0]);
    case 'ads_token':
        // Client asks for a signed token to present to Adsgram or to validate client-side result
        $type = $_GET['type'] ?? 'boost'; // 'boost' or 'chest' or 'quiz_skip'
        $tok = sign_token(['uid'=>$uid,'type'=>$type,'ts'=>time()]);
        json_ok(['token'=>$tok]);
    default:
        json_err('Unknown action');
}
?>
