<?php
// Very lightweight Telegram WebApp auth. In production, validate initData using your bot token.
function tg_user_from_init() {
    // Expect Telegram WebApp to POST 'init_data' or pass via header. For demo, accept raw user json.
    $raw = $_POST['init_data'] ?? $_GET['init_data'] ?? '';
    if (!$raw) { return null; }
    // If it's JSON with a 'user' field, use it; otherwise try parse querystring-style.
    if ($raw && ($obj=json_decode($raw, true)) && isset($obj['user'])) {
        return $obj['user'];
    }
    // Fallback: try to decode URL-encoded data, looking for "user=" json
    parse_str($raw, $arr);
    if(isset($arr['user'])){
        $user = json_decode($arr['user'], true);
        return $user ?: null;
    }
    return null;
}

function upsert_user($pdo, $tg_user, $ref=0) {
    $id = intval($tg_user['id'] ?? 0);
    $name = trim(($tg_user['first_name'] ?? '').' '.($tg_user['last_name'] ?? ''));
    $username = $tg_user['username'] ?? '';
    if(!$id){ return null; }
    // Insert or update
    $stmt = $pdo->prepare("INSERT INTO users (id, name, username, coins, pet_level, boost_until, referred_by, created_at, last_seen) 
        VALUES (:id,:name,:username,0,1,0,:ref, NOW(), NOW())
        ON DUPLICATE KEY UPDATE name=VALUES(name), username=VALUES(username), last_seen=NOW()");
    $stmt->execute([':id'=>$id, ':name'=>$name, ':username'=>$username, ':ref'=>$ref ?: null]);
    // If referral binding and not already bound
    if($ref && $ref != $id){
        $pdo->prepare("UPDATE users SET referred_by = IF(referred_by IS NULL, :ref, referred_by) WHERE id=:id")->execute([':ref'=>$ref,':id'=>$id]);
    }
    // Return full row
    $row = $pdo->query("SELECT * FROM users WHERE id={$id}")->fetch();
    return $row;
}
?>
